set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 3.

**1. Data prep
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	
	*create panel structure
	tsset cross year
	
	*indicator for decades
	gen decade=1970 		if year<=1980
	replace decade=1980 	if year<=1990&decade==.
	replace decade=1990 	if year<=2000&decade==.
	replace decade=2000 	if year<=2007&decade==.
	tab decade, gen(d)

	*Indicator for sectors
	tab sectorgroup, gen(s)
	
	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)

	drop if D1_lnlaborshare==.
	
**2. Top panel: linear timetrend, common across decades and sectors
	
	*Employment
	qui xi:reg D1_lnEMP  [w=weight_c], cluster(ic)
		est store T3_1
	keep if e(sample)==1
	*Hours
	qui xi:reg D1_lnH_EMP  [w=weight_h_c], cluster(ic)
		est store T3_2
	*Nominal hrly wage
	qui xi:reg D1_lnhwage  [w=weight_h_c], cluster(ic)
		est store T3_3		
	*Real hrly wage
	qui xi:reg D1_lnhwage_r  [w=weight_h_c], cluster(ic)
		est store T3_4	
	*Nominal value added
	qui xi:reg D1_lnVA  [w=weight_VA_c], cluster(ic)
		est store T3_5
	*Laborshare
	qui xi:reg D1_lnlaborshare  [w=weight_VA_c], cluster(ic)
		est store T3_6
	*Leave-out TFP
	qui xi:reg D1_lnTFPva_oth  [w=weight_VA_c], cluster(ic)
		est store T3_7
		
	esttab T3_1 T3_2 T3_3 T3_4 T3_5 T3_6 T3_7, keep(_cons) b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) 
	
	cap estimates drop _all
	
**3. Middle panel: linear timetrend, decade specific
	foreach var in d1 d2 d3 d4 {
		gen year`var'=year*`var'
	}
	
	local decdums "d1 d2 d3 d4"
	
	*Employment
	qui xi:reg D1_lnEMP `decdums'  [w=weight_c], nocons cluster(ic)
		est store T3_1
	*Hours
	qui xi:reg D1_lnH_EMP  `decdums'  [w=weight_h_c], nocons cluster(ic)
		est store T3_2
	*Nominal hrly wage
	qui xi:reg D1_lnhwage `decdums'  [w=weight_h_c], nocons cluster(ic)
		est store T3_3
	*Real hrly wage
	qui xi:reg D1_lnhwage_r `decdums'  [w=weight_h_c], nocons cluster(ic)
		est store T3_4
	*Nominal value added
	qui xi:reg D1_lnVA `decdums'  [w=weight_VA_c], nocons cluster(ic)
		est store T3_5
	*Laborshare
	qui xi:reg D1_lnlaborshare `decdums'  [w=weight_VA_c], nocons cluster(ic)
		est store T3_6
	*Leave-out TFP
	qui xi:reg D1_lnTFPva_oth `decdums'  [w=weight_VA_c], nocons cluster(ic)
		est store T3_7
		
	esttab T3_1 T3_2 T3_3 T3_4 T3_5 T3_6 T3_7, keep(`decdums') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) 
		
	cap estimates drop _all

**4. Bottom panel: linear timetrend, sector specific	
	foreach var in s1 s2 s3 s4 s5 {
		gen year`var'=year*`var'
	}
	
	local secdums "s1 s2 s3 s4 s5"
	
	*Employment
	qui xi:reg D1_lnEMP `secdums'  [w=weight_c], nocons cluster(ic)
		est store T3_1
	*Hours
	qui xi:reg D1_lnH_EMP  `secdums'  [w=weight_h_c], nocons cluster(ic)
		est store T3_2
	*Nominal hrly wage
	qui xi:reg D1_lnhwage `secdums'  [w=weight_h_c], nocons cluster(ic)
		est store T3_3
	*Real hrly wage
	qui xi:reg D1_lnhwage_r `secdums'  [w=weight_h_c], nocons cluster(ic)
		est store T3_4
	*Nominal value added
	qui xi:reg D1_lnVA `secdums'  [w=weight_VA_c], nocons cluster(ic)
		est store T3_5
	*Laborshare
	qui xi:reg D1_lnlaborshare `secdums'  [w=weight_VA_c], nocons cluster(ic)
		est store T3_6
	*Leave-out TFP
	qui xi:reg D1_lnTFPva_oth `secdums'  [w=weight_VA_c], nocons cluster(ic)
		est store T3_7
		
	esttab T3_1 T3_2 T3_3 T3_4 T3_5 T3_6 T3_7, keep(`secdums') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) 
		

